#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/ltdGDn

float smoothing = 0.1;
float ballradius = 0.0;
float metaPow = 1.0;
float densityMin = 4.0;
float densityMax= 7.0;
float densityEvolution = 0.4;
float rotationSpeed = 0.005;
vec2 moveSpeed = vec2(0.1,0.0);
float distortion = 0.05;
float nstrenght = 1.0;
float nsize = 1.0;
vec3 lightColor = vec3(7.0,8.0,10.0);

float saturate1(float x)
{
    return clamp(x, 0.0, 1.0);
}
vec2 rotuv(vec2 uv, float angle, vec2 center)
{    
   	return mat2(cos(angle), -sin(angle), sin(angle), cos(angle)) * (uv - center) + center;
}
float hash(float n)
{
   return fract(sin(dot(vec2(n,n) ,vec2(12.9898,78.233))) * 43758.5453);  
}  

float metaBall(vec2 uv)
{
	return length(fract(uv) - vec2(0.5));
}

float metaNoiseRaw(vec2 uv, float density)
{
    float v = 0.99;
    float r0 = hash(2015.3548);
    float s0 = iTime*(r0-0.5)*rotationSpeed;
    vec2 f0 = iTime*moveSpeed*r0;
    vec2 c0 = vec2(hash(31.2), hash(90.2)) + s0;   
    vec2 uv0 = rotuv(uv*(1.0+r0*v), r0*360.0 + s0, c0) + f0;    
    float metaball0 = saturate1(metaBall(uv0)*density);
    
    for(int i = 0; i < 25; i++)
    {
        float inc = float(i) + 1.0;
    	float r1 = hash(2015.3548*inc);
        float s1 = iTime*(r1-0.5)*rotationSpeed;
        vec2 f1 = iTime*moveSpeed*r1;
    	vec2 c1 = vec2(hash(31.2*inc), hash(90.2*inc))*100.0 + s1;   
    	vec2 uv1 = rotuv(uv*(1.0+r1*v), r1*360.0 + s1, c1) + f1 - metaball0*distortion;    
    	float metaball1 = saturate1(metaBall(uv1)*density);
        
        metaball0 *= metaball1;
    }
    
    return pow(metaball0, metaPow);
}

float metaNoise(vec2 uv)
{ 
    float density = mix(densityMin,densityMax,sin(iTime*densityEvolution)*0.5+0.5);
    return 1.0 - smoothstep(ballradius, ballradius+smoothing, metaNoiseRaw(uv, density));
}

vec4 calculateNormals(vec2 uv, float s)
{
    float offsetX = nsize*s/iResolution.x;
    float offsetY = nsize*s/iResolution.y;
	vec2 ovX = vec2(0.0, offsetX);
	vec2 ovY = vec2(0.0, offsetY);
    
	float X = (metaNoise(uv - ovX.yx) - metaNoise(uv + ovX.yx)) * nstrenght;
    float Y = (metaNoise(uv - ovY.xy) - metaNoise(uv + ovY.xy)) * nstrenght;
    float Z = sqrt(1.0 - saturate1(dot(vec2(X,Y), vec2(X,Y))));
    
    float c = abs(X+Y);
	return normalize(vec4(X,Y,Z,c));
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = fragCoord.xy / iResolution.xy;
    
    vec2 uv2 = uv;
    uv2.x *= iResolution.x/iResolution.y;
    uv2 *= vec2(1.0,0.75);
    uv2.y += sin(uv.x*0.5);
    uv2 += iTime*moveSpeed;

    vec2 sphereUvs = uv - vec2(0.5);
    float vign = length(sphereUvs);
    sphereUvs = (sphereUvs / (1.0 + vign))*1.5;
    
    float noise = metaNoise(uv2);
    
    vec4 n = calculateNormals(uv2, smoothstep(0.0, 0.5, 1.0 - vign));
    vec3 lDir = normalize(vec3(1.0,1.0,0.0));
    float l = max(0.0, dot(n.xyz, lDir));
      
    vec4 tex = texture(iChannel0, sphereUvs + n.xy + iTime*moveSpeed*-0.2).xxxx*0.75;
    tex *= 1.0 - vign;
    
    vec3 col = mix(tex.xyz*0.75, tex.xyz+l*lightColor, noise);
    
	fragColor = vec4(n.w*col*5.0 + col, 1.0);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


